<?php
if (isset($_POST["act"])) {
    $m_islem = [
        "mi_tip" => $_POST["mi_tip"],
        "mi_tur" => $_POST["mi_tur"],
        "mi_proje" => $_POST["mi_proje"],
        "mi_tarih" => ($_POST["mi_tarih"]) ? strtotime($_POST["mi_tarih"]) : time(),
        "mi_tutar" => str_replace([" TL", ","], ["", ""], $_POST["mi_tutar"]),
        "mi_ekleyen" => $_SESSION["baf_oturum"]["id"]
    ];

    try {
        $db->ekle("muhasebe_islemler", $m_islem);
        $_SESSION["baf_mesaj"][] = ["label" => "success", "message" => "İşlem Oluşturuldu"];
    } catch (\Exception $e) {

    }

}

?>
<div class="page-body">
    <div class="row">
        <div class="col-sm-12">
            <!-- Tab variant tab card start -->
            <div class="card">
                <div class="card-block tab-icon">
                    <!-- Row start -->
                    <form method="post" action="#" enctype="multipart/form-data">
                        <input type="hidden" name="act" value="insert">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="card-block tab-content p-t-20">
                                    <?php
                                    if (isset($_SESSION['baf_mesaj'])) {
                                        foreach ($_SESSION['baf_mesaj'] as $mesaj) {
                                            echo alert($mesaj['label'], $mesaj['message']);
                                            unset($_SESSION['baf_mesaj']);
                                        }
                                    }
                                    ?>
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <div class="row">
                                                <div class="col-md-4 form-group">
                                                    <label for="mi_tip">İşlem Yönü</label>
                                                    <select name="mi_tip" id="mi_tip" class="form-control" required>
                                                        <option value="" selected disabled>İşlem Tipi Seçin</option>
                                                        <option value="1">Gelir</option>
                                                        <option value="2">Gider</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-4 form-group">
                                                    <label for="mi_tur">İşlem Kategorisi</label>
                                                    <select name="mi_tur" id="mi_tur" class="form-control" required>
                                                        <option value="" selected disabled>Kategori Seçin</option>
                                                        <?php
                                                        $kategoriler = $db->getir("muhasebe_islem_turleri", null, "mit_baslik asc");
                                                        foreach ($kategoriler as $kategori):
                                                            ?>
                                                            <option value="<?= $kategori["mit_id"]; ?>"><?= $kategori["mit_baslik"]; ?></option>
                                                        <?php
                                                        endforeach;
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-4 form-group">
                                                    <label for="mi_proje">Proje</label>
                                                    <select name="mi_proje" id="mi_proje" class="form-control">
                                                        <option value="" selected disabled>Proje Seçin</option>
                                                        <?php
                                                        $projeler = $db->getir("projeler", ["pr_durum" => 1], "pr_adi asc");
                                                        foreach ($projeler as $proje):
                                                            ?>
                                                            <option value="<?= $proje["pr_id"]; ?>"><?= $proje["pr_adi"]; ?></option>
                                                        <?php
                                                        endforeach;
                                                        ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="mi_proje">İşlem Tarihi</label>
                                                    <input class="form-control" type="date" name="mi_tarih">
                                                </div>
                                                <div class="col-md-6 form-group">
                                                    <label for="mi_tutar">İşlem Tutarı</label>
                                                    <input class="form-control" type="text" name="mi_tutar">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-danger float-right">
                                    <i class="feather icon-save"></i> Kaydet
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Tab variant tab card start -->
        </div>
    </div>
</div>
</div>
</div>
</div>
</div>