<?php
$get = json_decode(json_encode($_GET, true));
?>
<!-- Page-body start -->
<div class="page-body">
    <!-- API plug-in methods table start -->
    <div class="card">
        <div class="card-header"></div>
        <div class="card-block">
            <form action="#" method="get">
                <div class="row">
                    <div class="col-md-12">
                        <h6 class="sub-title">SİPARİŞ FİLTRELEME </h6>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Sipariş NO.</label>
                        <input type="text" class="form-control" name="sp_id" value="<?= isset($get->sp_id) ? $get->sp_id : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Müşteri</label>
                        <input type="text" class="form-control" name="sp_musteri" value="<?= isset($get->sp_musteri) ? $get->sp_musteri : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Telefon Numarası</label>
                        <input type="text" class="form-control" name="sp_telefon" value="<?= isset($get->sp_telefon) ? $get->sp_telefon : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="urun_id">Ürün</label>
                        <select name="urun_id" id="urun_id" class="form-control">
                            <option value="" disabled selected>Ürün</option>
                            <?php
                            $urunler = $db->getir("urunler", ["urun_durum" => 1], "urun_baslik asc");
                            foreach ($urunler as $urun) {
                                $urunSelected = ($_GET["urun_id"] == $urun["urun_id"]) ? "selected" : "";
                                echo "<option value='{$urun["urun_id"]}' {$urunSelected}>{$urun["urun_baslik"]}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="sp_siparis_durumu">Listelenecek Veri</label>
                        <input type="text" class="form-control" name="listelenecek_veri" value="<?= (isset($get->listelenecek_veri)) ? $get->listelenecek_veri : ""; ?>">
                    </div>
                    <div class="col-md-12 form-group">
                        <button class="btn btn-danger float-right"><i class="feather icon-search"></i> Filtrele</button>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <form method="post">
                    <table class="table table-striped table-bordered">
                        <thead>
                        <tr>
                            <th><input type="checkbox" name="hepsini_sec"/></th>
                            <th>#</th>
                            <th>MÜŞTERİ</th>
                            <th>SİPARİŞ BİLGİLERİ</th>
                            <th>SİPARİŞ DURUMU</th>
                            <th>SİPARİŞ TARİHİ</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $siparislerSayfa = $sips->getCikartilacakSiparislerCount();
                        $sayfalama = sayfalama($siparislerSayfa);
                        $siparisler = $sips->getCikartilacakSiparisler(null, $sayfalama["baslangic"]);
                        getSayfalama($siparislerSayfa);
                        if (!$siparisler["data"]):
                            echo "<tr><td align='center' colspan='7'>Veri Bulunamadı</td></tr>";
                        endif;
                        foreach ($siparisler["data"] as $sip):
                            $aktarim = ($sip["sp_kargo_barkod"]) ? "bg-primary" : "";
                            ?>
                            <tr id="<?= $sip["sp_id"]; ?>" class="<?= $aktarim; ?>">
                                <td><input type="checkbox" name="siparisler_chkbx[]" value="<?= $sip["sp_id"]; ?>"/>
                                </td>
                                <td><?= $sip["sp_id"]; ?></td>
                                <td><?= $sip["sp_musteri"]; ?></td>
                                <td><?= $sip["su_adet"]; ?> Adet <?= $sip["urun_baslik"]; ?></td>
                                <td>
                                    <span class="badge bg-<?= $sip["durum_etiket"]; ?>"><?= $sip["durum_baslik"]; ?></span>
                                </td>
                                <td><?= date("d-m-Y H:i:s", $sip["sp_tarih"]); ?></td>
                                <td>
                                    <a href="<?= _URL; ?>/siparisler/detay/<?= $sip["sp_id"]; ?>" target="_blank">
                                        <button type="button" class="btn btn-warning btn-sm">İncele</button>
                                    </a>
                                    <?php if ($sip["sp_kargo_barkod"]): ?>
                                        <a href="<?= _URL; ?>/islem/etiket/<?= $sip["sp_id"]; ?>" target="_blank">
                                            <button type="button" class="btn btn-info btn-sm">Etiket</button>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th><input type="checkbox" name="hepsini_sec"/></th>
                            <th>#</th>
                            <th>MÜŞTERİ</th>
                            <th>SİPARİŞ BİLGİLERİ</th>
                            <th>SİPARİŞ DURUMU</th>
                            <th>SİPARİŞ TARİHİ</th>
                            <th></th>
                        </tr>
                        </tfoot>
                    </table>
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <button class="btn btn-danger" formtarget="_blank" formaction="<?= _URL; ?>/islem/kargo_aktarim">Kargoya Aktar</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php
                            echo getSayfalama($siparislerSayfa);
                            echo $sayfalama["toplam_data"] . " adetten " . count($siparisler["data"]) . " adet gösteriliyor.";
                            ?>
                        </div>
                        <div class="col-md-6">
                            <button type="button" class="btn btn-danger float-right" name="excel_olustur" onclick="siparisExcelOlustur('cikartilacak_siparisler')" value='<?= json_encode($_GET, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>'>Excel Oluştur</button>
                            <button type="button" class="btn btn-primary float-right mr-1" name="siparisler_toplu_islemler" onclick="cokluDuzenlemePanel()">ÇOKLU DÜZENLEME</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Page-body start -->
</div>
</div>
</div>
</div>