<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

try {
    if ($_POST["type"] == "checked") {
        $seciliSiparisler = $_POST["seciliSiparisler"];
        $seciliSiparisler = implode(",", $seciliSiparisler);
        $sipQry = "select * from siparisler as sip";
        $sipQry .= " join adres_sehirler as seh on sip.sp_sehir = seh.sehir_id";
        $sipQry .= " join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $sipQry .= " join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $sipQry .= " join adres_ilceler as ilc on sip.sp_ilce = ilc.ilce_id";
        $sipQry .= " join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $sipQry .= " join odeme_yontemleri as ody on sip.sp_odeme_yontemi = ody.od_id";
        $sipQry .= " left join kargo_firmalari as kgf on sip.sp_kargo = kgf.kf_id";
        $sipQry .= " where sp_durum = 1 and sp_siparis_durumu = 3 and sp_id in ({$seciliSiparisler})";

        if (isset($_POST["id"]) && ctype_digit($_POST["id"]))
            $sipQry .= " and sp_kargo = " . $_POST["id"];

        $sipQry .= " group by sp_id";
        $sips = $db->sorguGetir($sipQry);

    } elseif ($_POST["type"] == "json") {
        $sips = json_decode($_POST["seciliSiparisler"]);
        unset($sips->action);
        $sipQry = "select * from siparisler as sip";
        $sipQry .= " join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $sipQry .= " join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $sipQry .= " join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $sipQry .= " join adres_sehirler as seh on sip.sp_sehir = seh.sehir_id";
        $sipQry .= " join adres_ilceler as ilc on sip.sp_ilce = ilc.ilce_id";
        $sipQry .= " join odeme_yontemleri as ody on sip.sp_odeme_yontemi = ody.od_id";
        $sipQry .= " left join kargo_firmalari as kgf on sip.sp_kargo = kgf.kf_id";
        $sipQry .= " where sp_durum = 1 and sp_siparis_durumu = 2";

        foreach ($sips as $key => $val) {
            if ($key == "action")
                continue;
            if ($key == "method")
                continue;
            if ($key == "kural")
                continue;
            if ($key == "id")
                continue;
            if ($key == "sayfa")
                continue;
            if (in_array($key, ["sp_musteri", "sp_telefon"]))
                $sipQry .= " and " . $key . " like '%" . $val . "%'";
            else {
                if ($key && $val)
                    $sipQry .= " and " . $key . " = " . $val;
            }
        }
        $sipQry .= " group by sp_id";
        $sips = $db->sorguGetir($sipQry);
    }

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

// Varsayılan şablon tanımlamaları
// Başlık tanımlamaları
    $varsayilan_sablon = $db->getirTek("sistem_excel_sablonlar", ["sablon_id" => $ayarlar[4]["a_first_value"]]);
    $sablon_degerler = json_decode($varsayilan_sablon["sablon_degerler"]);
    for ($i = 0; $i < count($sablon_degerler); $i++) {
        $sheet->setCellValue($alfabe[$i + 1] . "1", __lang($sablon_degerler[$i]));
    }

    for ($s = 0; $s < count($sips); $s++) {
        $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu join urunler as u on sipu.su_urun_id = u.urun_id where su_siparis_id = {$sips[$s]["sp_id"]}");
        $sp_urun_adet_ad_secenek = "";
        $sp_urun_adet_ad = "";
        foreach ($urunler as $urun) {
            $urun_baslik = $urun["urun_baslik"];
            $urun_adet = $urun["su_adet"];
            $urun_varyasyon = "";
            $sp_urun_secenek = "";
            $u_varyasyonlar = (!empty(json_decode($urun["su_varyasyonlar"], true))) ? array_keys(json_decode($urun["su_varyasyonlar"], true)) : [];
            $u_varyasyonlar_degerler = json_decode($urun["su_varyasyonlar"], true);
            $u_varyasyonlar_string = "";
            if (!empty($u_varyasyonlar)) {
                for ($ad = 0; $ad < $urun_adet; $ad++) {
                    for ($vary = 0; $vary < count($u_varyasyonlar_degerler); $vary++) {
                        $u_varyasyonlar_string .= $u_varyasyonlar_degerler[$u_varyasyonlar[$vary]][$ad] . " ";
                    }
                    if ($ad + 1 < $urun_adet)
                        $u_varyasyonlar_string .= " , ";
                }
            }
            /*
            foreach ($u_varyasyonlar as $key => $value) {
                $urun_varyasyon .= strtoupper($key) . ": ";
                $u_varys = implode(", ", $value);
                $urun_varyasyon .= $u_varys . " ";
            }
            */
            $sp_urun_adet_ad_secenek .= $urun_adet . " Adet " . $urun_baslik . " " . $u_varyasyonlar_string . " - ";
            $sp_urun_adet_ad .= $urun_adet . " Adet " . $urun_baslik;
            $sp_urun_secenek .= $u_varyasyonlar_string;
        }
        for ($harf = 0; $harf < count($sablon_degerler); $harf++) {
            $satir = $s + 2;
            $satir = $alfabe[$harf + 1] . $satir;
            switch ($sablon_degerler[$harf]) {
                case "sp_id":
                    $deger = $sips[$s]["sp_id"];
                    break;
                case "sp_musteri":
                    $deger = $sips[$s]["sp_musteri"];
                    break;
                case "sp_telefon":
                    $deger = $sips[$s]["sp_telefon"];
                    break;
                case "sp_adres":
                    $deger = $sips[$s]["sp_adres"];
                    break;
                case "sp_sehir_ilce":
                    $deger = $sips[$s]["sehir_adi"] . " / " . $sips[$s]["ilce_adi"];
                    break;
                case "sp_sehir":
                    $deger = $sips[$s]["sehir_adi"];
                    break;
                case "sp_ilce":
                    $deger = $sips[$s]["ilce_adi"];
                    break;
                case "sp_odeme_yontemi":
                    $deger = $sips[$s]["od_baslik"];
                    break;
                case "sp_urun_adet":
                    $deger = $sips[$s]["su_adet"];
                    break;
                case "sp_urun_adet_ad_secenek":
                    $deger = $sp_urun_adet_ad_secenek;
                    break;
                case "sp_urun_adet_ad":
                    $deger = $sp_urun_adet_ad;
                    break;
                case "sp_urun_secenek":
                    $deger = $sp_urun_secenek;
                    break;
                case "sp_kargo_ucreti":
                    $deger = $sips[$s]["sp_kargo_ucreti"];
                    break;
                case "sp_siparis_tutari":
                    $deger = $sips[$s]["sp_siparis_tutari"];
                    break;
                case "sp_urun_adi":
                    $deger = $sips[$s]["urun_baslik"];
                    break;
                case "sp_tutar_kargo_ucreti":
                    $deger = $sips[$s]["sp_siparis_tutari"] + $sips[$s]["sp_kargo_ucreti"];
                    break;
                case "sp_ana_kargo_firmasi":
                    $deger = $sips[$s]["kf_baslik"];
                    break;    
                default:
                    $deger = "tanımlama gerekiyor => " . $sablon_degerler[$harf];
                    break;
            }
            $sheet->setCellValue($satir, $deger);
        }

    }

    $filename = "assets/files/uploads/siparis_excel/siparisler-" . date("d_m_y_h_i_s") . ".xls";
    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);

    $sonuc["durum"] = true;
    $sonuc["url"] = _URL . "/" . $filename;
    $sonuc["mesaj"] = "Excel oluşturuldu.";
    echo json_encode($sonuc, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (\Exception $e) {

}
?>