<?php

namespace Tonkul;

use DB;

class Tonkul
{
    const modul_adi = "Tonkul Kargo Entegrasyon Modulü";
    const modul_aciklama = "Tonkul Kargo Entegrasyon Modulü İçin";
    const modul_kod = "tonkul";
    const modul_tip = "kargo";
    const base_url = "https://beta.tonkul.com.tr/rest/";
    const gerekli_alanlar = [
        ["alan_adi" => "kullanici_kodu", "alan_title" => "Kullanıcı Kodu"],
        ["alan_adi" => "e_posta", "alan_title" => "E-Posta"],
        ["alan_adi" => "sifre", "alan_title" => "Şifre"],
        ["auth_kodu" => "auth_kod", "alan_title" => "Authorization Kodu"],
    ];
    const odeme_tipi_secenekleri = [
        ["kod" => "nakit", "baslik" => "Tahsilatsız Çıkış"],
        ["kod" => "kredi", "baslik" => "Kapıda Kartla Ödeme"],
        ["kod" => "pesin", "baslik" => "Kapıda Nakit Ödeme"]
    ];

    public function __construct()
    {
        //$modul_domain = "bafpanel";
        //lisansKontrol($modul_domain, $modul_domain . " domainine ait TONKUL modülü " . $_SERVER['SERVER_NAME'] . " domainine kurulmaya çalışıldı.");
    }

    public function Kurulum()
    {
        global $db;
        echo "Kurulum başlıyor...";
        $modul["modul_tip"] = "kargo";
        $modul["modul_kodu"] = "tonkul";
        $modul["modul_adi"] = "Tonkul Kargo Entegrasyonu";
        $modul["modul_durum"] = 1;
        $modulKurulumKontrol = $db->getirTek("sistem_moduller", ["modul_kodu" => $modul["modul_kodu"]]);
        if ($modulKurulumKontrol) {
            echo "<br />Modül kurulumu zaten yapılmış.";
        } else {
            $insertModul = $db->ekle("sistem_moduller", $modul);
            $db->sorguGetir("CREATE TABLE modul_tonkul_ayarlar (
                                    ta_id int(11) not null auto_increment primary key,
                                    ta_baslik varchar(250) not null,
                                    ta_kod varchar(250),
                                    ta_deger varchar(250),
                                    ta_tip varchar(250)
                                    )");
            if ($insertModul) {
                echo "<br />Modül verileri oluşturuldu...";
            }
        }
    }

    public function Ayarlar()
    {
        global $db;
        if (isset($_POST["odeme_tipi"])) :
            foreach ($_POST["odeme_tipi"] as $key => $value) {
                $kontrol = $db->getirTek("modul_tonkul_ayarlar", ["ta_tip" => "odeme_tipi", "ta_kod" => $key]);
                if (!$kontrol) {
                    $ayar["ta_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["ta_kod"] = $key;
                    $ayar["ta_deger"] = $value;
                    $ayar["ta_tip"] = "odeme_tipi";
                    $ayarEkle = $db->ekle("modul_tonkul_ayarlar", $ayar);
                } else {
                    $ayar["ta_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["ta_kod"] = $key;
                    $ayar["ta_deger"] = $value;
                    $ayar["ta_tip"] = "odeme_tipi";
                    $db->guncelle("modul_tonkul_ayarlar", $ayar, ["ta_id" => $kontrol["ta_id"]]);
                }
            }
        endif;
        $odemeTipleri = $db->getir("odeme_yontemleri", ["od_durum" => 1], "od_baslik asc");
        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>ÖDEME TİPİ EŞLEŞTİRMELERİ</h6>";
        $ekran .= "</div>";
        foreach ($odemeTipleri as $od) :
            $ekran .= "<div class='col-md-6 form-group'>";
            $ekran .= "<label>#{$od["od_id"]} {$od["od_baslik"]}</label>";
            $ekran .= "<select class='form-control' name='odeme_tipi[{$od["od_id"]}]'>";
            $odeme_ayar = $db->getirTek("modul_tonkul_ayarlar", ["ta_tip" => "odeme_tipi", "ta_kod" => $od["od_id"]]);
            $selected = "";
            foreach (self::odeme_tipi_secenekleri as $key => $value) :
                if ($odeme_ayar) {
                    if ($odeme_ayar["ta_deger"] == $value["kod"]) {
                        $selected = "selected";
                    } else {
                        $selected = "";
                    }
                }
                $ekran .= "<option value='{$value["kod"]}' {$selected}>{$value["kod"]} - {$value["baslik"]}</option>";
            endforeach;
            $ekran .= "</select>";
            $ekran .= "</div>";
        endforeach;
        $ekran .= "<div class='col-md-12'><button class='btn btn-danger'>Kaydet</button>";
        $ekran .= "</form>";
        echo $ekran;
    }

    public function DataAktar($data_id)
    {
        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent from siparisler
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 where sp_id = " . $data_id;

        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);
        $tonkul_key = md5($ent->e_posta . "_" . $ent->sifre) . "_" . $ent->kullanici_kodu;
        $aktarim_url = self::base_url . "insertKargo";
        $ch = curl_init();
        $headers = array(
            'Authorization: Bearer: ' . $ent->auth_kod
        );
        curl_setopt($ch, CURLOPT_URL, $aktarim_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $headers);
        $rest = curl_exec($ch);
        echo $rest;
        exit();
        //echo $rest;
    }
}
