<?php

namespace Tfm;

use DB;

class Tfm
{
    const modul_adi = "TFM Express Kargo Entegrasyon Modulü";
    const modul_aciklama = "TFM Express Kargo Entegrasyon Modulü İçin";
    const modul_kod = "tfmex";
    const modul_tip = "kargo";
    const base_url = "https://api.tfmex.com/TFMservice.svc/rest/";
    const gerekli_alanlar = [
        ["alan_adi" => "accountno", "alan_title" => "Account No"],
        ["alan_adi" => "username", "alan_title" => "Username"],
        ["alan_adi" => "refno", "alan_title" => "Ref. No"]
    ];
    const odeme_tipi_secenekleri = [
        /*["kod" => "nakit", "baslik" => "Tahsilatsız Çıkış"],
        ["kod" => "kredi", "baslik" => "Kapıda Kartla Ödeme"],
        ["kod" => "pesin", "baslik" => "Kapıda Nakit Ödeme"]*/
    ];

    public function __construct()
    {
        //$modul_domain = "bafpanel";
        //lisansKontrol($modul_domain, $modul_domain . " domainine ait TONKUL modülü " . $_SERVER['SERVER_NAME'] . " domainine kurulmaya çalışıldı.");
    }

    public static function Kurulum()
    {
        global $db;
        echo "Kurulum başlıyor...";
        $modul["modul_tip"] = "kargo";
        $modul["modul_kodu"] = "tfmex";
        $modul["modul_adi"] = "TFM Express Kargo Entegrasyonu";
        $modul["modul_dir"] = "Tfm.php";
        $modul["modul_durum"] = 1;
        $modulKurulumKontrol = $db->getirTek("sistem_moduller", ["modul_kodu" => $modul["modul_kodu"]]);
        if ($modulKurulumKontrol) {
            echo "<br />Modül kurulumu zaten yapılmış.";
        } else {
            $insertModul = $db->ekle("sistem_moduller", $modul);
            $db->sorguGetir("CREATE TABLE modul_tfmex_ayarlar (
                                    ta_id int(11) not null auto_increment primary key,
                                    ta_baslik varchar(250) not null,
                                    ta_kod varchar(250),
                                    ta_deger varchar(250),
                                    ta_tip varchar(250)
                                    )");
            if ($insertModul) {
                echo "<br />Modül verileri oluşturuldu...";
            }
        }
    }

    public function Ayarlar()
    {
        global $db;
        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        //$ekran .= "<div class='col-md-12'><button class='btn btn-danger'>Kaydet</button>";
        $ekran .= "</form>";
        echo $ekran;
    }

    public static function DataAktar($data_id)
    {
        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent,kf.kf_kod as satici, akf.kf_kod as branch_code from siparisler as sp
                                                 left join adres_ulkeler as aul on aul.ulke_id = sp.sp_ulke  
                                                 left join adres_sehirler as ash on ash.sehir_id = sp.sp_sehir  
                                                 left join adres_ilceler as ai on ai.ilce_id = sp.sp_ilce  
                                                 left join adres_mahalleler as am on am.mah_id = sp.sp_mahalle  
                                                 left join adres_cad_sok as acs on acs.cs_id = sp.sp_cad_sok  
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 left join kurlar as kur on kur.kur_id = sp_kur  
                                                 where sp_id = " . $data_id;
        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);
        $adresText = "";
        if (!empty($sp->mah_adi))
            $adresText .= $sp->mah_adi;
        if (!empty($sp->cs_adi))
            $adresText .= $sp->cs_adi;
        $adresText .= $sp->sp_adres;

        // Ürünler
        $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu 
                                                            join urunler as u on sipu.su_urun_id = u.urun_id
                                                            join urunler_birimler as u_b on sipu.su_birim_id = u_b.ub_id
                                                            where su_siparis_id = {$sp->sp_id}");
        $sp_urun_adet_ad_secenek = "";
        foreach ($urunler as $urun) {
            $urun_baslik = $urun["urun_baslik"];
            $urun_adet = $urun["su_adet"];
            $urun_birim = $urun["ub_baslik"];
            $sp_urun_secenek = "";
            $u_varyasyonlar = (!empty($urun["su_varyasyonlar"]) || $urun["su_varyasyonlar"] != "") ? @array_keys(json_decode($urun["su_varyasyonlar"], true)) : null;
            $u_varyasyonlar_degerler = json_decode($urun["su_varyasyonlar"], true);
            $u_varyasyonlar_string = "";
            for ($ad = 0; $ad < $urun_adet; $ad++) {
                if (!empty($u_varyasyonlar_degerler)) {
                    for ($vary = 0; $vary < count($u_varyasyonlar_degerler); $vary++) {
                        $u_varyasyonlar_string .= $u_varyasyonlar_degerler[$u_varyasyonlar[$vary]][$ad] . " ";
                    }
                    if ($ad + 1 < $urun_adet)
                        $u_varyasyonlar_string .= " , ";
                }
            }
            $sp_urun_adet_ad_secenek .= $urun_adet . " " . $urun_birim . " " . $urun_baslik . " " . $u_varyasyonlar_string;
        }
        // Ürünler

        $data = array(
            "accountno" => $ent->accountno,
            "username" => $ent->username,
            "service" => "COD",
            "refno" => $ent->refno,
            "CONSIGNORREF" => "",
            "CONSIGNEE" => $sp->sp_musteri,
            "CONSIGNEEMOBILE" => $sp->sp_telefon,
            "CONSIGNEEADDRESS" => $adresText,
            "CONSIGNEETOWN" => $sp->sehir_kodu,
            "CONSIGNEEZIPCODE" => "",
            "CONSIGNEECOUNTRY" => $sp->ulke_adi,
            "CONSIGNEETELPHONE" => $sp->sp_telefon,
            "CONSIGNEEFAX" => "",
            "CONSIGNEEMAILADDRESS" => "tes@gmail.com",
            "CONSIGNEEATTENTION" => "1",
            "DESTINATIONCODE" => $sp->sehir_kodu,
            "PIECES" => "1",
            "TOTALWEIGHT" => "0",
            "CURRENCY" => $sp->kur_simge,
            "VALUEAMT" => $sp->sp_siparis_tutari + $sp->sp_kargo_ucreti,
            "TYPEOFSHIPMENT" => "NON DOCS",
            "CONTENTS" => $sp_urun_adet_ad_secenek,
            "TOTALVOLWEIGHT" => "0",
            "CODAMT" => $sp->sp_siparis_tutari + $sp->sp_kargo_ucreti,
            "CONSIGNORNOTE" => "",
            "SELLER" => "mob",
            "PICKUP_COMPANY" => "21",
            "PICKUP_COUNTRY" => "UAE",
            "PICKUP_CITY" => "DUBAI",
            "PICKUP_ADDRESS" => "mob",
            "PRINTOPTION" => "0"
        );
        $serviceUrl = "https://api.tfmex.com/TFMservice.svc/rest/awb2pdf";
        $jsonData = json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

        $options = array(
            CURLOPT_HTTPHEADER => array(
                "Content-Type:application/json; charset=utf-8",
                "Content-Length:" . strlen($jsonData)));
        $defaults = array(
            CURLOPT_POST => 1,
            CURLOPT_HEADER => 0,
            CURLOPT_URL => $serviceUrl,
            CURLOPT_FRESH_CONNECT => 1,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_FORBID_REUSE => 1,
            CURLOPT_TIMEOUT => 4,
            CURLOPT_POSTFIELDS => $jsonData
        );

        $ch = curl_init();
        curl_setopt_array($ch, ($options + $defaults));
        $content = curl_exec($ch);
        curl_close($ch);
        return $content;
    }
}