<?php

namespace AjanNet;

use DB;

class AjanNet
{
    const modul_adi = "Ajan.Net Kargo Entegrasyon Modulü";
    const modul_aciklama = "Ajan.Net / POSTMAN Entegrasyonu.";
    const modul_kod = "ajannet";
    const modul_tip = "kargo";
    const gerekli_alanlar = [
        ["alan_adi" => "URL", "alan_title" => "Rest API URL"],
        ["alan_adi" => "From", "alan_title" => "E-Posta"],
        ["alan_adi" => "Authorization", "alan_title" => "API Key"],
    ];
    const odeme_tipi_secenekleri = [
        ["kod" => "2", "baslik" => "Ücret Alıcı"],
        ["kod" => "3", "baslik" => "Peşin Ödeme"],
        ["kod" => "6", "baslik" => "Kapıda Kredi Kartı"]
    ];

    const kargo_durumlari = [
        ["kod" => "0", "baslik" => "PAKETLEME"],
        ["kod" => "1", "baslik" => "TESLİMLER"],
        ["kod" => "2", "baslik" => "İADELER"],
        ["kod" => "3", "baslik" => "HABER FORMLARI"],
        ["kod" => "4", "baslik" => "DAĞITIMDA"],
        ["kod" => "5", "baslik" => "KAYIP"],
        ["kod" => "6", "baslik" => "SORUNLU"]
    ];

    public static function Kurulum()
    {
        global $db;
        echo "Kurulum başlıyor...";
        $modul["modul_tip"] = "kargo";
        $modul["modul_kodu"] = "ajannet";
        $modul["modul_adi"] = "AjanNet Kargo Entegrasyonu";
        $modul["modul_dir"] = "AjanNet.php";
        $modul["modul_durum"] = 1;
        $modulKurulumKontrol = $db->getirTek("sistem_moduller", ["modul_kodu" => $modul["modul_kodu"]]);
        if ($modulKurulumKontrol) {
            echo "<br />Modül kurulumu zaten yapılmış.";
        } else {
            $insertModul = $db->ekle("sistem_moduller", $modul);
            $db->sorguGetir("CREATE TABLE `modul_ajannet_ayarlar` (
                                 `an_id` int(11) NOT NULL AUTO_INCREMENT,
                                 `an_baslik` varchar(250) NOT NULL,
                                 `an_kod` varchar(250) DEFAULT NULL,
                                 `an_deger` varchar(250) DEFAULT NULL,
                                 `an_tip` varchar(250) DEFAULT NULL,
                                 PRIMARY KEY (`an_id`)
                                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            if ($insertModul) {
                echo "<br />Modül verileri oluşturuldu...";
            }
        }
    }

    public function Ayarlar()
    {
        global $db;

        if (!empty($_POST["kargo_durum_siparis_kodu"])) {
            for ($i = 0; $i < count($_POST["kargo_durum_siparis_kodu"]); $i++) {
                $kargodurum[$_POST["kargo_durum_kodu"][$i]] = $_POST["kargo_durum_siparis_kodu"][$i];
            }
            $kargo_durum_kontrol = $db->getirTek("modul_ajannet_ayarlar", ["an_tip" => "kargo_durum_kodlari"]);
            if (empty($kargo_durum_kontrol)) {
                $db->ekle("modul_ajannet_ayarlar", ["an_baslik" => "Kargo Sipariş Durumları", "an_kod" => 0, "an_deger" => json_encode($kargodurum, JSON_FORCE_OBJECT), "an_tip" => "kargo_durum_kodlari"]);
            } else {
                $db->guncelle("modul_ajannet_ayarlar", ["an_deger" => json_encode($kargodurum, JSON_FORCE_OBJECT)], ["an_tip" => "kargo_durum_kodlari"]);
            }
        }

        if (!empty($_POST["odeme_tipi"])) {
            foreach ($_POST["odeme_tipi"] as $key => $value) {
                $kontrol = $db->getirTek("modul_ajannet_ayarlar", ["an_tip" => "odeme_tipi", "an_kod" => $key]);
                if (!$kontrol) {
                    $ayar["an_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["an_kod"] = $key;
                    $ayar["an_deger"] = $value;
                    $ayar["an_tip"] = "odeme_tipi";
                    $ayarEkle = $db->ekle("modul_ajannet_ayarlar", $ayar);
                } else {
                    $ayar["an_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["an_kod"] = $key;
                    $ayar["an_deger"] = $value;
                    $ayar["an_tip"] = "odeme_tipi";
                    $db->guncelle("modul_ajannet_ayarlar", $ayar, ["an_id" => $kontrol["an_id"]]);
                }
            }
        }


        $odemeTipleri = $db->getir("odeme_yontemleri", ["od_durum" => 1], "od_baslik asc");
        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>ÖDEME TİPİ EŞLEŞTİRMELERİ</h6>";
        $ekran .= "</div>";
        foreach ($odemeTipleri as $od) :
            $ekran .= "<div class='col-md-6 form-group'>";
            $ekran .= "<label>#{$od["od_id"]} {$od["od_baslik"]}</label>";
            $ekran .= "<select class='form-control' name='odeme_tipi[{$od["od_id"]}]'>";
            $odeme_ayar = $db->getirTek("modul_ajannet_ayarlar", ["an_tip" => "odeme_tipi", "an_kod" => $od["od_id"]]);
            $selected = "";
            foreach (self::odeme_tipi_secenekleri as $key => $value) :
                if ($odeme_ayar) {
                    if ($odeme_ayar["an_deger"] == $value["kod"]) {
                        $selected = "selected";
                    } else {
                        $selected = "";
                    }
                }
                $ekran .= "<option value='{$value["kod"]}' {$selected}>{$value["kod"]} - {$value["baslik"]}</option>";
            endforeach;
            $ekran .= "</select>";
            $ekran .= "</div>";
        endforeach;
        $kargoDurumEslestirmeler = $db->getirTek("modul_ajannet_ayarlar", ["an_tip" => "kargo_durum_kodlari"]);
        if (!empty($kargoDurumEslestirmeler)) {
            $kargoDurumEsJson = json_decode($kargoDurumEslestirmeler["an_deger"], true);
        }
        $ekran .= "<div class='col-md-6'>";
        $ekran .= "<h6 class='sub-title'>KARGO DURUM KODU EŞLEŞTİRMELERİ</h6>";
        $ekran .= "<table class='table table-bordered'>";
        $ekran .= "<thead>";
        $ekran .= "<tr>";
        $ekran .= "<th>KARGO DURUMU</th>";
        $ekran .= "<th>KARGO DURUM KODU</th>";
        $ekran .= "<th>SİPARİŞ DURUMU</th>";
        $ekran .= "</tr>";
        $ekran .= "</thead>";
        $ekran .= "<tbody>";
        for ($i = 0; $i < count(self::kargo_durumlari); $i++) :
            $durum = self::kargo_durumlari[$i];
            $ekran .= "<tr>";
            $ekran .= "<td>{$durum["baslik"]}</td>";
            $ekran .= "<td><input name='kargo_durum_kodu[]' value='{$durum["kod"]}' class='form-control'></td>";
            $ekran .= "<td>";
            $ekran .= "<select name='kargo_durum_siparis_kodu[]' class='form-control'>";
            $ekran .= "<option value=''>KARGO DURUMU</option>";
            $siparisDurumlari = $db->getir("siparis_durumlari", ["durum_durum" => 1]);
            foreach ($siparisDurumlari as $durum) {
                $selected = (!empty($kargoDurumEsJson) && $kargoDurumEsJson[$i] == $durum["durum_id"]) ? "selected" : "";
                $ekran .= "<option value='{$durum["durum_id"]}' {$selected}>{$durum["durum_baslik"]}</option>";
            }
            $ekran .= "</select>";
            $ekran .= "</td>";
            $ekran .= "</tr>";
        endfor;
        $ekran .= "</tbody>";
        $ekran .= "</table>";
        $ekran .= "</div>";
        $ekran .= "<div class='col-md-12'><button class='btn btn-danger'>Kaydet</button>";
        $ekran .= "</form>";
        echo $ekran;
    }

    public static function DataAktar($data_id)
    {
        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent,kf.kf_kod as satici, akf.kf_kod as branch_code from siparisler as sp
                                                 left join adres_sehirler as ash on ash.sehir_id = sp.sp_sehir  
                                                 left join adres_ilceler as ai on ai.ilce_id = sp.sp_ilce  
                                                 left join adres_mahalleler as am on am.mah_id = sp.sp_mahalle  
                                                 left join adres_cad_sok as acs on acs.cs_id = sp.sp_cad_sok  
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 where sp_id = " . $data_id;
        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);
        $adresText = "";
        if (!empty($sp->mah_adi))
            $adresText .= $sp->mah_adi;
        if (!empty($sp->cs_adi))
            $adresText .= $sp->cs_adi;
        $adresText .= $sp->sp_adres;
        // Kargo datası oluşturuluyor

        // Ürünler
        $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu 
                                                            join urunler as u on sipu.su_urun_id = u.urun_id
                                                            join urunler_birimler as u_b on sipu.su_birim_id = u_b.ub_id
                                                            where su_siparis_id = {$sp->sp_id}");
        $sp_urun_adet_ad_secenek = "";
        foreach ($urunler as $urun) {
            $urun_baslik = $urun["urun_baslik"];
            $urun_adet = $urun["su_adet"];
            $urun_birim = $urun["ub_baslik"];
            $sp_urun_secenek = "";
            $u_varyasyonlar = (!empty($urun["su_varyasyonlar"]) || $urun["su_varyasyonlar"] != "") ? @array_keys(json_decode($urun["su_varyasyonlar"], true)) : null;
            $u_varyasyonlar_degerler = json_decode($urun["su_varyasyonlar"], true);
            $u_varyasyonlar_string = "";
            for ($ad = 0; $ad < $urun_adet; $ad++) {
                if (!empty($u_varyasyonlar_degerler)) {
                    for ($vary = 0; $vary < count($u_varyasyonlar_degerler); $vary++) {
                        $u_varyasyonlar_string .= $u_varyasyonlar_degerler[$u_varyasyonlar[$vary]][$ad] . " ";
                    }
                    if ($ad + 1 < $urun_adet)
                        $u_varyasyonlar_string .= " , ";
                }
            }
            $sp_urun_adet_ad_secenek .= $urun_adet . " " . $urun_birim . " " . $urun_baslik . " " . $u_varyasyonlar_string;
        }
        // Ürünler

        $barkod = substr($sp->sp_id . time() . rand(1000, 9999), 0, 12);
        $ajannet_ayarlar = $db->getirTek("modul_ajannet_ayarlar", ["an_kod" => $sp->sp_odeme_yontemi, "an_tip" => "odeme_tipi"]);

        $data["customer"] = $sp->sp_musteri;
        //$data["customer"] = "test";
        $data["province_name"] = $sp->sehir_adi;
        $data["county_name"] = $sp->ilce_adi;
        $data["address"] = $adresText;
        $data["telephone"] = $sp->sp_telefon;
        $data["branch_code"] = $sp->branch_code;
        $data["barcode"] = $barkod;
        $data["amount"] = ($sp->sp_siparis_tutari + $sp->sp_kargo_ucreti);
        $data["summary"] = $sp_urun_adet_ad_secenek;
        $data["quantity"] = 1;
        $data["amount_type_id"] = $ajannet_ayarlar["an_deger"];
        $data["order_number"] = $sp->sp_id;
        $data["output_number"] = $sp->sp_id;
        $data["seller"] = $sp->satici;
        // Kargo datası oluşturuluyor

        $url = $ent->URL . "/restapi/client/consignment/add";
        $header = array("Authorization: {$ent->Authorization}", "From: {$ent->From}");
        $user_agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; tr; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.6';
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_USERAGENT, $user_agent);
        curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        $response = curl_exec($curl);
        return $response;
    }

    public static function DataKontrol($data_id)
    {
        global $db;
        $getData = $db->sorguGetir("select * from siparisler as sip 
                                                  left join kargo_firmalari as kf on sip.sp_kargo = kf.kf_id
                                                  join siparisler_kargo_cikislar as skc on sip.sp_kargo_barkod = skc.skc_barkod
                                                  join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id
                                                  where sp_id = {$data_id}");
        $sp = $getData[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);

        if (!empty($getData)) {
            $url = $ent->URL . "/restapi/client/tracking";
            $header = array("Authorization: {$ent->Authorization}", "From: {$ent->From}");
            $user_agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; tr; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.6';
            $data["barkod"] = $sp->skc_barkod;
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_USERAGENT, $user_agent);
            curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            $response = curl_exec($curl);
            return $response;
        }
    }
}
