<?php

class DB
{

    public $db;

    public function __construct()
    {
        $host = db_host;
        $user = db_username;
        $database = db_name;
        $password = db_password;
        try {
            $this->db = new PDO("mysql:host=" . $host . ";dbname=" . $database . ";charset=utf8", $user, $password);
        } catch (PDOException $e) {
            //print_r($e);
            if (strpos($e, "Access denied for user")) {
                echo "Veritabanı ayarlarını kontrol edin.";
            } elseif (strpos($e, "php_network_getaddresses")) {
                echo "Veritabanı bağlantı hatası.";
            }
            exit();
        }
        $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        $this->db->exec("SET time_zone = '+03:00'");
    }

    public static function baglan()
    {
        $db = new PDO("mysql:host=" . db_host . ";dbname=" . db_name . ";charset=utf8", db_username, db_password);
        return $db;
    }

    public function getirTek($tablo, $where = null)
    {
        $query = "select * from " . $tablo;
        if ($where) {
            $query .= " where ";
            $param = 0;
            foreach ($where as $key => $value) {
                $param++;
                $query .= " {$key} = '{$value}'";
                if (count($where) > $param) {
                    $query .= " and ";
                }
            }
        }
        return $this->db->query($query)->fetch(PDO::FETCH_ASSOC);
    }

    public function getir($tablo, $where = null, $order = '', $limit = null)
    {
        $query = "select * from " . $tablo;
        if ($where && count($where)) {
            $query .= " where ";
            $param = 0;
            foreach ($where as $key => $value) {
                $param++;
                $query .= " {$key} =:" . $key;
                if (count($where) > $param) {
                    $query .= " and ";
                }
            }
        }

        if ($order) {
            $query .= " order by " . $order;
        }

        if ($limit) {
            $query .= " limit " . $limit;
        }

        $sr = $this->db->prepare($query);
        $sr->execute($where);
        $sonuc = $sr->fetchAll();
        return $sonuc;
    }

    public function guncelle($tablo, $veri, $where)
    {
        $query = "update {$tablo} set ";
        $paramVeri = 0;
        foreach ($veri as $key => $value) {
            $paramVeri++;
            $query .= " {$key} =:" . $key;
            if (count($veri) > $paramVeri) {
                $query .= ",";
            }
        }

        if ($where) {
            $veriler = array_merge($veri, $where);
            $query .= " where ";
            $paramWhere = 0;
            foreach ($where as $key => $value) {
                $paramWhere++;
                $query .= " {$key} =:" . $key;
                if (count($where) > $paramWhere) {
                    $query .= " and ";
                }
            }
        } else {
            $veriler = $veri;
        }
        $update = $this->db->prepare($query)->execute($veriler);
        if ($update) {
            return true;
        } else {
            return false;
        }
    }

    public function ekle($tablo, $veri)
    {
        $query = "insert into {$tablo} set ";
        $paramVeri = 0;
        foreach ($veri as $key => $value) {
            $paramVeri++;
            $query .= $key . "=:" . $key;
            if (count($veri) > $paramVeri) {
                $query .= ",";
            }
        }

        $update = $this->db->prepare($query)->execute($veri);
        if ($update) {
            return true;
        } else {
            return false;
        }
    }

    public function sonEklenen($tableName = null)
    {
        return $this->db->lastInsertId($tableName);
    }

    public function sorguGetir($query)
    {
        return $this->db->query($query)->fetchAll();
    }

    public function duzSorguCalistir($query)
    {
        $this->db->query($query)->execute();
    }
}
