<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$sipQry = "select * from siparisler as sip";
$sipQry .= " left join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
$sipQry .= " left join urunler as ur on s_ur.su_urun_id = ur.urun_id";
$sipQry .= " left join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
$sipQry .= " left join urunler_birimler as u_b on s_ur.su_birim_id = u_b.ub_id";
$sipQry .= " left join adres_sehirler as seh on sip.sp_sehir = seh.sehir_id";
$sipQry .= " left join adres_ilceler as ilc on sip.sp_ilce = ilc.ilce_id";
$sipQry .= " left join odeme_yontemleri as ody on sip.sp_odeme_yontemi = ody.od_id";
$sipQry .= " left join kargo_firmalari as kgf on sip.sp_kargo = kgf.kf_id";
$sipQry .= " where sp_durum = 1 and sp_siparis_durumu not in (1,7,10)";
$sipQry .= " group by sp_id";
$sips = $db->sorguGetir($sipQry);

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setCellValue("A1", "Müşteri");
$sheet->setCellValue("B1", "İlçe");
$sheet->setCellValue("C1", "Şehir");
$sheet->setCellValue("D1", "Adres");
$sheet->setCellValue("E1", "Telefon");
$sheet->setCellValue("F1", "Sip. No.");
$sheet->setCellValue("G1", "Toplam Tutar");
$sheet->setCellValue("H1", "Ürün");
$sheet->setCellValue("I1", "Ödeme Yöntemi");
$sheet->setCellValue("J1", "Sip. Durumu");

for ($s = 0; $s < count($sips); $s++) {
    $adres = "";
    $sl = $s + 2;
    $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu join urunler as u on sipu.su_urun_id = u.urun_id join urunler_birimler as u_b on sipu.su_birim_id = u_b.ub_id where su_siparis_id = {$sips[$s]["sp_id"]}");
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue("A{$sl}", $sips[$s]["sp_musteri"]);
    $sheet->setCellValue("B{$sl}", $sips[$s]["ilce_adi"]);
    $sheet->setCellValue("C{$sl}", $sips[$s]["sehir_adi"]);
    $sheet->setCellValue("D{$sl}", $sips[$s]["sp_adres"]);
    $sheet->setCellValue("E{$sl}", $sips[$s]["sp_telefon"]);
    $sheet->setCellValue("F{$sl}", $sips[$s]["sp_id"]);
    $sheet->setCellValue("G{$sl}", ($sips[$s]["sp_siparis_tutari"] + $sips[$s]["sp_kargo_ucreti"]));
    $sheet->setCellValue("H{$sl}", $sips[$s]["su_adet"] . " Adet " . $sips[$s]["urun_baslik"]);
    $sheet->setCellValue("I{$sl}", $sips[$s]["od_baslik"]);
    $sheet->setCellValue("J{$sl}", $sips[$s]["durum_baslik"]);
}
$filename = "assets/files/uploads/siparis_excel/siparisler-" . date("d_m_y_h_i_s") . ".xls";
$writer = new Xlsx($spreadsheet);
$writer->save($filename);

$sonuc["durum"] = true;
$sonuc["url"] = _URL . "/" . $filename;
$sonuc["mesaj"] = "Excel oluşturuldu.";
echo json_encode($sonuc, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

?>