<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

try {
    if ($_POST["type"] == "checked") {
        $seciliSiparisler = $_POST["seciliSiparisler"];
        $seciliSiparisler = implode(",", $seciliSiparisler);
        $sipQry = "select *,sip.sp_id,s_ur.su_id from siparisler as sip";
        $sipQry .= " left join adres_sehirler as seh on sip.sp_sehir = seh.sehir_id";
        $sipQry .= " left join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $sipQry .= " left join urunler_birimler as u_b on s_ur.su_birim_id = u_b.ub_id";
        $sipQry .= " left join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $sipQry .= " left join adres_ilceler as ilc on sip.sp_ilce = ilc.ilce_id";
        $sipQry .= " left join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $sipQry .= " left join odeme_yontemleri as ody on sip.sp_odeme_yontemi = ody.od_id";
        $sipQry .= " left join kargo_firmalari as kgf on sip.sp_kargo = kgf.kf_id";
        $sipQry .= " where sp_durum = 1 and sp_id in ({$seciliSiparisler})";

        if (!empty($_SESSION['baf_oturum']['k_siteler']))
            $sipQry .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

        //$sipQry .= " group by sip.sp_id";
        $sips = $db->sorguGetir($sipQry);

    } elseif ($_POST["type"] == "json") {
        $sips = json_decode($_POST["seciliSiparisler"]);
        unset($sips->action);
        $sipQry = "select * from siparisler as sip";
        $sipQry .= " left join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $sipQry .= " left join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $sipQry .= " left join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $sipQry .= " left join urunler_birimler as u_b on s_ur.su_birim_id = u_b.ub_id";
        $sipQry .= " left join adres_sehirler as seh on sip.sp_sehir = seh.sehir_id";
        $sipQry .= " left join adres_ilceler as ilc on sip.sp_ilce = ilc.ilce_id";
        $sipQry .= " left join odeme_yontemleri as ody on sip.sp_odeme_yontemi = ody.od_id";
        $sipQry .= " left join kargo_firmalari as kgf on sip.sp_kargo = kgf.kf_id";
        $sipQry .= " where sp_durum = 1";

        if (!empty($_SESSION['baf_oturum']['k_siteler']))
            $sipQry .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";


        foreach ($sips as $key => $val) {
            if ($key == "action")
                continue;
            if ($key == "method")
                continue;
            if ($key == "kural")
                continue;
            if ($key == "id")
                continue;
            if ($key == "sayfa")
                continue;
            if (in_array($key, ["sp_musteri", "sp_telefon"]) && !empty($val))
                $sipQry .= " and " . $key . " like '%" . $val . "%'";
            elseif (in_array($key, ["sp_tarih_ilk"]) && !empty($val)) {
                $getDayStart = \Carbon\Carbon::createFromTimestamp(strtotime($val))->startOfDay()->getTimestamp();
                $query .= " and sp_tarih >= '{$getDayStart}'";
            } elseif (in_array($key, ["sp_tarih_son"]) && $val != '') {
                $getDayEnd = \Carbon\Carbon::createFromTimestamp(strtotime($val))->endOfDay()->getTimestamp();
                $query .= " and sp_tarih <=  '{$getDayEnd}'";
            } else {
                if ($key && $val)
                    $sipQry .= " and " . $key . " = " . $val;
            }
        }
        //$sipQry .= " group by sip.sp_id";
        $sips = $db->sorguGetir($sipQry);
    }

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Varsayılan şablon tanımlamaları
    // Başlık tanımlamaları
    $sistemExcelSablon = $db->sorguGetir("SELECT * FROM sistem_excel_sablonlar WHERE sablon_varsayilan = 1");
    if (!$sistemExcelSablon) {
        $sonuc["durum"] = false;
        $sonuc["mesaj"] = "Excel şablonu bulunamadı.";
        echo json_encode($sonuc, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }
    $sablon_degerler = json_decode($sistemExcelSablon[0]["sablon_degerler"]);
    for ($i = 0; $i < count($sablon_degerler); $i++) {
        $sheet->setCellValue($alfabe[$i + 1] . "1", __lang($sablon_degerler[$i]));
    }

    for ($s = 0; $s < count($sips); $s++) {
        $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu 
                                                            join urunler as u on sipu.su_urun_id = u.urun_id
                                                            join urunler_birimler as u_b on sipu.su_birim_id = u_b.ub_id
                                                            where su_siparis_id = {$sips[$s]["sp_id"]}");
        $sp_urun_adet_ad_secenek = "";
        $sp_urun_adet_ad = "";
        foreach ($urunler as $urun) {
            $urun_baslik = $urun["urun_baslik"];
            $urun_adet = $urun["su_adet"];
            $urun_birim = $urun["ub_baslik"];
            $urun_paketler = json_decode($urun['urun_paketler'], true);
            $urun_varyasyon = "";
            $sp_urun_secenek = "";
            $su_varyasyonlar = json_decode($urun["su_varyasyonlar"], true);
            if (is_array($su_varyasyonlar) && !empty($su_varyasyonlar)) {
                $u_varyasyonlar = array_keys($su_varyasyonlar);
                $u_varyasyonlar_degerler = $su_varyasyonlar;
            } else {
                $u_varyasyonlar = [];
                $u_varyasyonlar_degerler = [];
            }
            $u_varyasyonlar_string = "";
            for ($ad = 0; $ad < $urun_adet; $ad++) {
                if (!empty($u_varyasyonlar_degerler)) {
                    for ($vary = 0; $vary < count($u_varyasyonlar_degerler); $vary++) {
                        $u_varyasyonlar_string .= $u_varyasyonlar_degerler[$u_varyasyonlar[$vary]][$ad] . " ";
                    }
                    if ($ad + 1 < $urun_adet)
                        $u_varyasyonlar_string .= " , ";
                }
            }
            $opsiyonel_1 = 'a';
            $opsiyonel_2 = '';
            foreach ($urun_paketler as $paket) {
                if ((int)$paket['urun_adet'] == (int)$urun_adet) {
                    $opsiyonel_1 = $paket['opsiyonel_1'];
                    $opsiyonel_2 = $paket['opsiyonel_2'];
                    break; // Uygun ürünü bulduktan sonra döngüden çıkıyoruz
                }
            }
            $sp_urun_adet_ad_secenek .= $urun_adet . " " . $urun_birim . " " . $urun_baslik . " " . $opsiyonel_1 . " " . $u_varyasyonlar_string;
            $sp_urun_adet_ad .= $urun_adet . " " . $urun_birim . " " . $urun_baslik;
            $sp_urun_secenek .= $u_varyasyonlar_string;
            
        }
        for ($harf = 0; $harf < count($sablon_degerler); $harf++) {
            $satir = $s + 2;
            $satir = $alfabe[$harf + 1] . $satir;
            switch ($sablon_degerler[$harf]) {
                case "sp_id":
                    $deger = $sips[$s]["sp_id"];
                    break;
                case "sp_musteri":
                    $deger = $sips[$s]["sp_musteri"];
                    break;
                case "sp_telefon":
                    $deger = $sips[$s]["sp_telefon"];
                    break;
                case "sp_adres":
                    $deger = $sips[$s]["sp_adres"];
                    break;
                case "sp_sehir_ilce":
                    $deger = $sips[$s]["sehir_adi"] . " / " . $sips[$s]["ilce_adi"];
                    break;
                case "sp_sehir":
                    $deger = $sips[$s]["sehir_adi"];
                    break;
                case "sp_ilce":
                    $deger = $sips[$s]["ilce_adi"];
                    break;
                case "sp_odeme_yontemi":
                    $deger = $sips[$s]["od_baslik"];
                    break;
                case "sp_urun_adet":
                    $deger = $sips[$s]["su_adet"];
                    break;
                case "sp_urun_adet_ad_secenek":
                    $deger = $sp_urun_adet_ad_secenek;
                    break;
                case "sp_urun_adet_ad_secenekler":
                    $deger = $sp_urun_adet_ad_secenek;
                    break;
                case "sp_urun_adet_ad":
                    $deger = $sp_urun_adet_ad;
                    break;
                case "sp_urun_secenek":
                    $deger = $sp_urun_secenek;
                    break;
                case "sp_kargo_ucreti":
                    $deger = $sips[$s]["sp_kargo_ucreti"];
                    break;
                case "sp_siparis_tutari":
                    $deger = $sips[$s]["sp_siparis_tutari"];
                    break;
                case "sp_urun_adi":
                    $deger = $sips[$s]["urun_baslik"];
                    break;
                case "sp_tutar_kargo_ucreti":
                    $deger = $sips[$s]["sp_siparis_tutari"] + $sips[$s]["sp_kargo_ucreti"];
                    break;
                case "sp_siparis_tutari_kargo_ucreti":
                    $deger = $sips[$s]["sp_siparis_tutari"] + $sips[$s]["sp_kargo_ucreti"];
                    break;
                case "sp_ana_kargo_firmasi":
                    $deger = $sips[$s]["kf_baslik"];
                    break;
                case "sp_kargo":
                    $deger = $sips[$s]["kf_baslik"];
                    break;
                default:
                    $deger = "tanımlama gerekiyor => " . $sablon_degerler[$harf];
                    break;
            }
            $sheet->setCellValue($satir, $deger);
        }

    }

    $filename = "assets/files/uploads/siparis_excel/siparisler-" . date("d_m_y_h_i_s") . ".xls";
    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);

    $sonuc["durum"] = true;
    $sonuc["url"] = _URL . "/" . $filename;
    $sonuc["mesaj"] = "Excel oluşturuldu.";
    echo json_encode($sonuc, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (\Exception $e) {

}
?>