<?php
$basTarih = isset($_GET["baslangic"]) ? strtotime($_GET["baslangic"]) : \Carbon\Carbon::now()->subDay(9)->getTimestamp();
$bitTarih = isset($_GET["bitis"]) ? strtotime($_GET["bitis"]) : time();

$data["baslangic"] = date("d-m-Y", $basTarih);
$data["bitis"] = date("d-m-Y", $bitTarih);
$data["labels"] = array();
$data["datasets"] = array();
$tarihler = \Carbon\CarbonPeriod::create($data["baslangic"], $data["bitis"]);
$sipQuery = "SELECT";
$tarihSayar = 0;
foreach ($tarihler as $tarih) {
    $tarihSayar++;
    $tBas = \Carbon\Carbon::createFromTimestamp(strtotime($tarih))->startOfDay()->getTimestamp();
    $tSon = \Carbon\Carbon::createFromTimestamp(strtotime($tarih))->endOfDay()->getTimestamp();
    $sipQuery .= " count(if(sp_tarih between '{$tBas}' and '{$tSon}',1,null)) as '" . strtotime($tarih) . "_siparis',";
    $sipQuery .= " sum(case when sp_tarih between '{$tBas}' and '{$tSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as '" . strtotime($tarih) . "_tutar',";
    $sipQuery .= " sum(case when sp_tarih between '{$tBas}' and '{$tSon}' then su_adet else 0 end) as '" . strtotime($tarih) . "_urun'";
    if ($tarihSayar < count($tarihler))
        $sipQuery .= ",";
    $tarih = date("d-m-Y", strtotime($tarih));
    $data["labels"][] = $tarih;
}
$sipQuery .= " FROM siparisler ";
$sipQuery .= " JOIN siparisler_urunler ON siparisler_urunler.su_siparis_id = siparisler.sp_id";
$sipQuery .= " WHERE sp_siparis_durumu NOT IN ({$rapor_haric_durumlar}) AND siparisler_urunler.su_durum = 1 AND siparisler.sp_durum = 1";

if (!empty($_SESSION['baf_oturum']['k_siteler'])) $sipQuery .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

$siparisler = $db->sorguGetir($sipQuery);

$siparisSayiData = array();

$siparisSayiDatalar = null;
$siparisCiroDatalar = null;
$siparisUrunDatalar = null;
foreach ($tarihler as $tarih) {
    $strTarih = strtotime($tarih);
    $siparisSayiDatalar[] = $siparisler[0]["{$strTarih}_siparis"];
    $siparisCiroDatalar[] = $siparisler[0]["{$strTarih}_tutar"];
    $siparisUrunDatalar[] = $siparisler[0]["{$strTarih}_urun"];
}

$data["datasets"][] = [
    "label" => "Sipariş Sayısı",
    "backgroundColor" => "rgba(34, 112, 147,1.0)",
    "borderColor" => "rgba(52, 172, 224,1.0)",
    "data" => $siparisSayiDatalar,
    "fill" => false,
    "yAxisID" => 'y',
];

$data["datasets"][] = [
    "label" => "Toplam Ciro",
    "backgroundColor" => "rgba(51, 217, 178,1.0)",
    "borderColor" => "rgba(33, 140, 116,1.0)",
    "data" => $siparisCiroDatalar,
    "fill" => false,
    "yAxisID" => 'y1',
];

$data["datasets"][] = [
    "label" => "Ürün Sayısı",
    "backgroundColor" => "rgba(205, 97, 51,1.0)",
    "borderColor" => "rgba(255, 121, 63,1.0)",
    "data" => $siparisUrunDatalar,
    "fill" => false,
    "yAxisID" => 'y2',
];

echo json_encode($data);