/* Ana sayfa sipariş karşılaştırma chart */
var labels = null;
var datasets = null;
$.ajax({
    url: "chartjs/getHomeKarsilastirma",
    method: "get",
    data: {},
    success: function (data) {
        var rJson = $.parseJSON(data);
        labels = rJson.labels;
        datasets = rJson.datasets;
    },
    async: false
});
var data = {
    labels: labels,
    datasets: datasets
}
var getHomeKarsilastirmaCfg = {
    type: 'line',
    data: data,
    options: {
        response: true,
        interaction: {
            mode: 'index',
            intersect: false
        },
        stacked: false,
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
                ticks: {
                    callback: function (value, index, tickes) {
                        return value + " Sip.";
                    }
                }
            }, y1: {
                type: 'linear',
                display: true,
                position: 'right',
                ticks: {
                    callback: function (value, index, tickes) {
                        var tutar = value.toLocaleString('tr-TR', {
                            style: 'currency',
                            currency: 'TRY',
                        });
                        return tutar;
                    }
                }
            }, y2: {
                type: 'linear',
                display: false,
                position: 'left',
                callback: function (value, index, tickes) {
                    return value + " Ürün";
                }
            },
        }
    }
}
const myChart = new Chart(
    document.getElementById('getHomeKarsilastirma'),
    getHomeKarsilastirmaCfg
);

$(function () {
    $('input[name="dateRangeBygetHomeKarsilastirma"]').daterangepicker({
        opens: 'left',
        "timePicker24Hour": true,
        ranges: {
            'Bugün': [moment(), moment()],
            'Dün': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Son 7 gün': [moment().subtract(6, 'days'), moment()],
            'Son 30 gün': [moment().subtract(29, 'days'), moment()],
            'Bu ay': [moment().startOf('month'), moment().endOf('month')],
            'Geçen ay': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        "applyClass": "btn btn-xs palmSplash",
        "cancelClass": "btn btn-xs red",
        locale: {
            format: "DD/MM/YYYY",
            "applyLabel": "Filtrele",
            "cancelLabel": "Vazgeç",
            "fromLabel": "Dan",
            "toLabel": "a",
            "customRangeLabel": "Tarih Seç",
            "daysOfWeek": [
                "Pt",
                "Sl",
                "Çr",
                "Pr",
                "Cm",
                "Ct",
                "Pz"
            ],
            "monthNames": [
                "Ocak",
                "Şubat",
                "Mart",
                "Nisan",
                "Mayıs",
                "Haziran",
                "Temmuz",
                "Ağustos",
                "Eylül",
                "Ekim",
                "Kasım",
                "Aralık"
            ],
            "firstDay": 1
        },
    }, function (start, end, label) {
        $.ajax({
            url: "chartjs/getHomeKarsilastirma",
            method: "get",
            data: {
                baslangic: start.format('YYYY-MM-DD'),
                bitis: end.format('YYYY-MM-DD'),
                label: label
            },
            success: function (data) {
                var rJson = $.parseJSON(data);
                labels = rJson.labels;
                datasets = rJson.datasets;
                var data = {
                    labels: labels,
                    datasets: datasets
                }
                myChart.data = data
                myChart.update();
            },
            async: false
        });
    });
});


$("i#refreshData").click(function () {
    var start = $('#dateRangeBygetHomeKarsilastirma').data('daterangepicker').startDate.format('DD/MM/YYYY');
    var end = $('#dateRangeBygetHomeKarsilastirma').data('daterangepicker').endDate.format('DD/MM/YYYY');
    $.ajax({
        url: "chartjs/getHomeKarsilastirma",
        method: "get",
        data: {
            baslangic: start,
            bitis: end
        },
        success: function (data) {
            var rJson = $.parseJSON(data);
            labels = rJson.labels;
            datasets = rJson.datasets;
            var data = {
                labels: labels,
                datasets: datasets
            }
            myChart.data = data
            myChart.update();
        },
        async: false
    });
});