<?php

namespace YurticiKargo;

use DB;
use SoapClient;
use PHPMailer\PHPMailer\Exception;

class YurticiKargo
{
    const modul_adi = "Yurtiçi Kargo Entegrasyon Modulü";
    const modul_aciklama = "Yurtiçi Kargo Modulü İçin";
    const modul_kod = "yurtici";
    const modul_tip = "kargo";
    const aktarim_url = "https://customerservices.araskargo.com.tr/arascargoservice/arascargoservice.asmx?wsdl";
    const kontrol_url = "https://customerservices.araskargo.com.tr/ArasCargoCustomerIntegrationService/ArasCargoIntegrationService.svc?wsdl";
    const gerekli_alanlar = [
    ];
    const odeme_tipi_secenekleri = [
    ];
    const kargo_durumlari = [
    ];

    public static function Kurulum()
    {
        global $db;
        echo "Kurulum başlıyor...";
        $modul["modul_tip"] = "kargo";
        $modul["modul_kodu"] = "yurtici";
        $modul["modul_adi"] = "Yurtiçi Kargo Entegrasyon Modulü";
        $modul["modul_dir"] = "Yurtici.php";
        $modul["modul_durum"] = 1;
        $modulKurulumKontrol = $db->getirTek("sistem_moduller", ["modul_kodu" => $modul["modul_kodu"]]);
        if ($modulKurulumKontrol) {
            echo "<br />Modül kurulumu zaten yapılmış.";
        } else {
            $insertModul = $db->ekle("sistem_moduller", $modul);
            $db->sorguGetir("CREATE TABLE IF NOT EXISTS `modul_yurtici_kargo_ayarlar` (
                                 `an_id` int(11) NOT NULL AUTO_INCREMENT,
                                 `an_baslik` varchar(250) NOT NULL,
                                 `an_kod` varchar(250) DEFAULT NULL,
                                 `an_deger` varchar(250) DEFAULT NULL,
                                 `an_tip` varchar(250) DEFAULT NULL,
                                 PRIMARY KEY (`an_id`)
                                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            if ($insertModul) {
                echo "<br />Modül verileri oluşturuldu...";
            }
        }
    }

    public function Ayarlar()
    {
        global $db;


        if (!empty($_POST["kargo_durum_siparis_kodu"])) {
            for ($i = 0; $i < count($_POST["kargo_durum_siparis_kodu"]); $i++) {
                $kargodurum[$_POST["kargo_durum_kodu"][$i]] = $_POST["kargo_durum_siparis_kodu"][$i];
            }
            $kargo_durum_kontrol = $db->getirTek("modul_aras_kargo_ayarlar", ["an_tip" => "kargo_durum_kodlari"]);
            if (empty($kargo_durum_kontrol)) {
                $db->ekle("modul_aras_kargo_ayarlar", ["an_baslik" => "Kargo Sipariş Durumları", "an_kod" => 0, "an_deger" => json_encode($kargodurum, JSON_FORCE_OBJECT), "an_tip" => "kargo_durum_kodlari"]);
            } else {
                $db->guncelle("modul_aras_kargo_ayarlar", ["an_deger" => json_encode($kargodurum, JSON_FORCE_OBJECT)], ["an_tip" => "kargo_durum_kodlari"]);
            }
        }

        if (!empty($_POST["odeme_tipi"])) {
            foreach ($_POST["odeme_tipi"] as $key => $value) {
                $kontrol = $db->getirTek("modul_aras_kargo_ayarlar", ["an_tip" => "odeme_tipi", "an_kod" => $key]);
                if (!$kontrol) {
                    $ayar["an_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["an_kod"] = $key;
                    $ayar["an_deger"] = $value;
                    $ayar["an_tip"] = "odeme_tipi";
                    $ayarEkle = $db->ekle("modul_aras_kargo_ayarlar", $ayar);
                } else {
                    $ayar["an_baslik"] = "#" . $key . " idli ödeme tipi";
                    $ayar["an_kod"] = $key;
                    $ayar["an_deger"] = $value;
                    $ayar["an_tip"] = "odeme_tipi";
                    $db->guncelle("modul_aras_kargo_ayarlar", $ayar, ["an_id" => $kontrol["an_id"]]);
                }
            }
        }


        $odemeTipleri = $db->getir("odeme_yontemleri", ["od_durum" => 1], "od_baslik asc");
        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>ÖDEME TİPİ EŞLEŞTİRMELERİ</h6>";
        $ekran .= "</div>";
        foreach ($odemeTipleri as $od) :
            $ekran .= "<div class='col-md-6 form-group'>";
            $ekran .= "<label>#{$od["od_id"]} {$od["od_baslik"]}</label>";
            $ekran .= "<select class='form-control' name='odeme_tipi[{$od["od_id"]}]'>";
            $odeme_ayar = $db->getirTek("modul_aras_kargo_ayarlar", ["an_tip" => "odeme_tipi", "an_kod" => $od["od_id"]]);
            $selected = "";
            foreach (self::odeme_tipi_secenekleri as $key => $value) :
                if ($odeme_ayar) {
                    if ($odeme_ayar["an_deger"] == $value["kod"]) {
                        $selected = "selected";
                    } else {
                        $selected = "";
                    }
                }
                $ekran .= "<option value='{$value["kod"]}' {$selected}>{$value["kod"]} - {$value["baslik"]}</option>";
            endforeach;
            $ekran .= "</select>";
            $ekran .= "</div>";
        endforeach;

        $odemeTipleri = $db->getir("odeme_yontemleri", ["od_durum" => 1], "od_baslik asc");
        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>ÖDEME TİPİ EŞLEŞTİRMELERİ</h6>";
        $ekran .= "</div>";

        foreach ($odemeTipleri as $od) :
            $ekran .= "<div class='col-md-6 form-group'>";
            $ekran .= "<label>#{$od["od_id"]} {$od["od_baslik"]}</label>";
            $ekran .= "<select class='form-control' name='odeme_tipi[{$od["od_id"]}]'>";
            $odeme_ayar = $db->getirTek("modul_aras_kargo_ayarlar", ["an_tip" => "odeme_tipi", "an_kod" => $od["od_id"]]);
            $selected = "";
            foreach (self::odeme_tipi_secenekleri as $key => $value) :
                if ($odeme_ayar) {
                    if ($odeme_ayar["an_deger"] == $value["kod"]) {
                        $selected = "selected";
                    } else {
                        $selected = "";
                    }
                }
                $ekran .= "<option value='{$value["kod"]}' {$selected}>{$value["kod"]} - {$value["baslik"]}</option>";
            endforeach;
            $ekran .= "</select>";
            $ekran .= "</div>";
        endforeach;


        $kargoDurumEslestirmeler = $db->getirTek("modul_aras_kargo_ayarlar", ["an_tip" => "kargo_durum_kodlari"]);
        if (!empty($kargoDurumEslestirmeler)) {
            $kargoDurumEsJson = json_decode($kargoDurumEslestirmeler["an_deger"], true);
        }
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>KARGO DURUM KODU EŞLEŞTİRMELERİ</h6>";
        $ekran .= "<table class='table table-bordered'>";
        $ekran .= "<thead>";
        $ekran .= "<tr>";
        $ekran .= "<th>KARGO DURUMU</th>";
        $ekran .= "<th>KARGO DURUM KODU</th>";
        $ekran .= "<th>SİPARİŞ DURUMU</th>";
        $ekran .= "</tr>";
        $ekran .= "</thead>";
        $ekran .= "<tbody>";
        for ($i = 0; $i < count(self::kargo_durumlari); $i++) :
            $durum = self::kargo_durumlari[$i];
            $ekran .= "<tr>";
            $ekran .= "<td>{$durum["baslik"]}</td>";
            $ekran .= "<td><input name='kargo_durum_kodu[]' value='{$durum["kod"]}' class='form-control'></td>";
            $ekran .= "<td>";
            $ekran .= "<select name='kargo_durum_siparis_kodu[]' class='form-control'>";
            $ekran .= "<option value=''>KARGO DURUMU</option>";
            $siparisDurumlari = $db->getir("siparis_durumlari", ["durum_durum" => 1]);
            foreach ($siparisDurumlari as $durum) {
                $selected = (!empty($kargoDurumEsJson) && $kargoDurumEsJson[$i] == $durum["durum_id"]) ? "selected" : "";
                $ekran .= "<option value='{$durum["durum_id"]}' {$selected}>{$durum["durum_baslik"]}</option>";
            }
            $ekran .= "</select>";
            $ekran .= "</td>";
            $ekran .= "</tr>";
        endfor;
        $ekran .= "</tbody>";
        $ekran .= "</table>";
        $ekran .= "</div>";


        $ekran .= "<div class='col-md-12'><button class='btn btn-danger'>Kaydet</button>";
        $ekran .= "</form>";
        echo $ekran;
    }

    public static function DataAktar($data_id)
    {
        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent,kf.kf_kod as satici, akf.kf_kod as branch_code from siparisler as sp
                                                 left join adres_sehirler as ash on ash.sehir_id = sp.sp_sehir  
                                                 left join adres_ilceler as ai on ai.ilce_id = sp.sp_ilce  
                                                 left join adres_mahalleler as am on am.mah_id = sp.sp_mahalle  
                                                 left join adres_cad_sok as acs on acs.cs_id = sp.sp_cad_sok  
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 where sp_id = " . $data_id;


        $adresText = "";
        $IsCod = null;
        $CodCollectionType = null;

        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);

        if (!empty($sp->mah_adi))
            $adresText .= $sp->mah_adi;
        if (!empty($sp->cs_adi))
            $adresText .= $sp->cs_adi;
        $adresText .= $sp->sp_adres;

        $odemeTipiQuery = $db->sorguGetir("select * from modul_aras_kargo_ayarlar where an_tip = 'odeme_tipi' and an_kod = {$sp->sp_odeme_yontemi}");

        $barkod = substr($sp->sp_id . time() . rand(1000, 9999), 0, 12);

        $return["UserName"] = $ent->UserName;
        $return["Password"] = $ent->Password;
        $return["TradingWaybillNumber"] = $sp->sp_id;
        $return["InvoiceNumber"] = $sp->sp_id;
        $return["IntegrationCode"] = $barkod;
        $return["ReceiverName"] = $sp->sp_musteri;
        $return["ReceiverAddress"] = $adresText;
        $return["ReceiverCityName"] = $sp->sehir_adi;
        $return["ReceiverTownName"] = $sp->ilce_adi;
        $return["ReceiverQuarterName"] = ($sp->mah_adi) ? $sp->mah_adi : null;
        $return["ReceiverAvenueName"] = ($sp->cs_adi) ? $sp->cs_adi : null;
        $return["ReceiverPhone1"] = $sp->sp_telefon;
        $return["IsCod"] = $isCod;
        $return["CodAmount"] = ($sp->sp_siparis_tutari + $sp->sp_kargo_ucreti);
        $return["CodCollectionType"] = ($isCod) ? $CodCollectionType : null;
        $return["CodBillingType"] = 0;
        $return["PayorTypeCode"] = $PayorTypeCode;
        $return["IsWorldWide"] = 0;

        $urun[0]["BarcodeNumber"] = $barkod . "01";
        $urun[0]["VolumetricWeight"] = 1;
        $urun[0]["Weight"] = 1;

        $return["PieceDetails"] = $urun;
        $return["PieceCount"] = 1;

        try {
            $client = new SoapClient(self::aktarim_url, array("encoding" => "UTF-8"));
            $response = $client->SetOrder(array("orderInfo" => array("Order" => $return), "userName" => $ent->Aktarim_UserName, "password" => $ent->Aktarim_Password));
            $returnKargo = (array)$response->SetOrderResult->OrderResultInfo;
            return $returnKargo;

        } catch (Exception $exc) {
            $return = $exc->getMessage();
            print_r($return);
        }
    }


    public static function DataKontrol($data_id)
    {
        $client = new SoapClient(self::kontrol_url, array("encoding" => "UTF-8"));

        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent,kf.kf_kod as satici, akf.kf_kod as branch_code from siparisler as sp
                                                 left join adres_sehirler as ash on ash.sehir_id = sp.sp_sehir  
                                                 left join adres_ilceler as ai on ai.ilce_id = sp.sp_ilce  
                                                 left join adres_mahalleler as am on am.mah_id = sp.sp_mahalle  
                                                 left join adres_cad_sok as acs on acs.cs_id = sp.sp_cad_sok  
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 where sp_id = " . $data_id;

        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);

        $loginInfo = '<LoginInfo><UserName>' . $ent->Rapor_UserName . '</UserName><Password>' . $ent->Rapor_Password . '</Password><CustomerCode>' . $ent->CustomerCode . '</CustomerCode></LoginInfo>';
        $queryInfo = '<QueryInfo><QueryType>11</QueryType><IntegrationCode>' . $sp->sp_kargo_barkod . '</IntegrationCode></QueryInfo>';
        $return = $client->GetQueryJSON(array("loginInfo" => $loginInfo, "queryInfo" => $queryInfo));
        return $return;
    }
}

