<?php

namespace Siparisler;

use DB;

class Siparisler
{
    public function getSiparisler($search = false, $baslangic = null)
    {
        global $db;

        $query = "SELECT sp_id, sp_musteri, sp_telefon, sp_adres,sp_siparis_tutari, sp_kaynak, sp_musteri_ip, site_url, durum_baslik, durum_etiket, sp_tarih, urun_baslik, su_adet, ub_baslik";
        //if (!isset($_GET["sp_telefon"])) $query .= ", count(sp_id) as mukerrer";
        //if (!isset($_GET["sp_telefon"])) $query .= ", GROUP_CONCAT(sp_id) as other_sips ";
        $query .= " FROM siparisler sip
             LEFT JOIN siparisler_urunler su ON sip.sp_id = su.su_siparis_id
             LEFT JOIN urunler u ON su.su_urun_id = u.urun_id
             LEFT JOIN siteler st ON st.site_id = sip.sp_site
             LEFT JOIN siparis_durumlari sd ON sd.durum_id = sip.sp_siparis_durumu
             LEFT JOIN urunler_birimler ub ON ub.ub_id = su.su_birim_id
         WHERE sp_durum = 1";
         
         if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

        foreach ($_GET as $key => $val) {
            $val = htmlspecialchars($val, ENT_QUOTES, 'UTF-8');
            if ($key == "action") continue;
            if ($key == "id") continue;
            if ($key == "method") continue;
            if ($key == "kural") continue;
            if ($key == "sayfa") continue;
            if ($key == "listelenecek_veri") continue;
            if (in_array($key, ["sp_musteri", "sp_telefon", "sp_musteri_ip"]) && !empty($val)) $query .= " and {$key} like \"%{$val}%\""; elseif (in_array($key, ["sp_tarih_ilk"]) && !empty($val)) {
                $getDayStart = \Carbon\Carbon::createFromTimestamp(strtotime($val))->startOfDay()->getTimestamp();
                $query .= " and sp_tarih >= '{$getDayStart}'";
            } elseif (in_array($key, ["sp_tarih_son"]) && $val != '') {
                $getDayEnd = \Carbon\Carbon::createFromTimestamp(strtotime($val))->endOfDay()->getTimestamp();
                $query .= " and sp_tarih <=  '{$getDayEnd}'";
            } else {
                if (isset($val) && $key && $val) $query .= " and {$key} =  '{$val}'";
            }
            if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
        }

        //if (!isset($_GET["sp_telefon"])) $query .= " GROUP BY sp_id";

        if (!isset($_GET["sp_telefon"])) $query .= " ORDER BY sp_tarih DESC";

        $sayfaBasiIcerik = (!empty($_GET["listelenecek_veri"])) ? $_GET["listelenecek_veri"] : _SAYFA_BASI_ICERIK;
        $query .= " limit ".$baslangic.",".$sayfaBasiIcerik;
        $sorgu = $db->sorguGetir($query);

        return ["sonuc_adet" => count($sorgu), "data" => $sorgu];
    }

    public function getSiparislerCount($search = false)
    {
        global $db;
        $query = "SELECT sp_id, sp_musteri, sp_telefon, sp_musteri_ip, site_url, durum_baslik, durum_etiket, sp_tarih, urun_baslik, su_adet, ub_baslik";
        //if (!isset($_GET["sp_telefon"])) $query .= ", count(sp_id) as mukerrer";
        //if (!isset($_GET["sp_telefon"])) $query .= ", GROUP_CONCAT(sp_id) as other_sips ";
        $query .= " FROM siparisler sip
             LEFT JOIN siparisler_urunler su ON sip.sp_id = su.su_siparis_id
             LEFT JOIN urunler u ON su.su_urun_id = u.urun_id
             LEFT JOIN siteler st ON st.site_id = sip.sp_site
             LEFT JOIN siparis_durumlari sd ON sd.durum_id = sip.sp_siparis_durumu
             LEFT JOIN urunler_birimler ub ON ub.ub_id = su.su_birim_id
         WHERE sp_durum = 1";

        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

        foreach ($_GET as $key => $val) {
            $val = htmlspecialchars($val, ENT_QUOTES, 'UTF-8');
            if ($key == "action") continue;
            if ($key == "id") continue;
            if ($key == "method") continue;
            if ($key == "kural") continue;
            if ($key == "sayfa") continue;
            if ($key == "listelenecek_veri") continue;
            if (isset($_GET[$key]) && in_array($key, ["sp_musteri", "sp_telefon"]) && !empty($val)) $query .= " and {$key} like \"%{$val}%\""; elseif (in_array($key, ["sp_tarih_ilk"]) && $val != '') {
                $getDayStart = \Carbon\Carbon::createFromTimestamp(strtotime($val))->startOfDay()->getTimestamp();
                $query .= " and sp_tarih >= '{$getDayStart}'";
            } elseif (in_array($key, ["sp_tarih_son"]) && $val != '') {
                $getDayEnd = \Carbon\Carbon::createFromTimestamp(strtotime($val))->endOfDay()->getTimestamp();
                $query .= " and sp_tarih <= '{$getDayEnd}'";
            } else {
                if (isset($val) && $key && $val) $query .= " and {$key} =  '{$val}'";
            }
        }

        //if (!isset($_GET["sp_telefon"])) $query .= " GROUP BY sp_id";

        if (!isset($_GET["sp_telefon"])) $query .= " ORDER BY sp_tarih DESC";

        $sorgu = $db->sorguGetir($query);
        return $sorgu;
    }

    public function getDurumSayilari()
    {
        global $db;
        $query = "select sip.sp_siparis_durumu,sd.durum_baslik, count(sp_id) as total from siparisler as sip";
        $query .= " join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $query .= " where sp_durum = 1 ";

        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";


        $goruntulenecek = json_decode(getAyarlar()[5]["a_first_value"]);
        if (!empty($goruntulenecek)) {
            $gd = implode(", ", $goruntulenecek);
            $query .= " and sp_siparis_durumu in ({$gd})";
        }

        $query .= " group by sip.sp_siparis_durumu";

        $sorgu = $db->sorguGetir($query);
        return $sorgu;
    }

    public function getCikartilacakSiparisler($search = false, $baslangic = null)
    {
        global $db;
        $query = "select * from siparisler as sip";
        $query .= " join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $query .= " join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $query .= " join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $query .= " where sp_durum = 1 and sp_siparis_durumu = 3";

        if (isset($_GET["id"]) && ctype_digit($_GET["id"])) $query .= " and sp_kargo = ".$_GET["id"];

        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";


        foreach ($_GET as $key => $val) {
            if ($key == "action") continue;
            if ($key == "id") continue;
            if ($key == "method") continue;
            if ($key == "kural") continue;
            if ($key == "sayfa") continue;
            if ($key == "listelenecek_veri") continue;
            if (in_array($key, ["sp_musteri", "sp_telefon"]) && $val != '') $query .= " and {$key} like '%{$val}%'"; else {
                if (isset($val) && $key && $val) $query .= " and {$key} =  '{$val}'";
            }
        }
//        $query .= " group by sp_id";
        $query .= " order by sp_id desc";
        $sayfaBasiIcerik = (!empty($_GET["listelenecek_veri"])) ? $_GET["listelenecek_veri"] : _SAYFA_BASI_ICERIK;
        $query .= " limit ".$baslangic.",".$sayfaBasiIcerik;
        $sorgu = $db->sorguGetir($query);
        return ["sonuc_adet" => count($sorgu), "data" => $sorgu];
    }

    public function getCikartilacakSiparislerCount($search = false)
    {
        global $db;
        $query = "select * from siparisler as sip";
        $query .= " join siparisler_urunler as s_ur on sip.sp_id = s_ur.su_siparis_id";
        $query .= " join urunler as ur on s_ur.su_urun_id = ur.urun_id";
        $query .= " join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id";
        $query .= " where sp_durum = 1 and sp_siparis_durumu = 3";

        if (isset($_GET["id"]) && ctype_digit($_GET["id"])) $query .= " and sp_kargo = ".$_GET["id"];

        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";


        foreach ($_GET as $key => $val) {
            if ($key == "action") continue;
            if ($key == "id") continue;
            if ($key == "method") continue;
            if ($key == "kural") continue;
            if ($key == "sayfa") continue;
            if ($key == "listelenecek_veri") continue;
            if (isset($_GET[$key]) && in_array($key, ["sp_musteri", "sp_telefon"])) $query .= " and {$key} like '%{$val}%'"; else {
                if (isset($val) && $key && $val) $query .= " and {$key} =  '{$val}'";
            }
        }
        $query .= " group by sp_id";
        $query .= " order by sp_id desc";
        $sorgu = $db->sorguGetir($query);
        return $sorgu;
    }


    public function getCikartilacaklarFirmalar()
    {
        global $db;
        $query = "select sip.sp_siparis_durumu,kf_id,kf_baslik, count(sp_id) as total from siparisler as sip";
        $query .= " left join kargo_firmalari as kf on sip.sp_kargo = kf.kf_id";
        $query .= " where sp_siparis_durumu = 3 and sp_durum = 1";
        $query .= " group by kf.kf_id";
        $sorgu = $db->sorguGetir($query);
        return $sorgu;
    }
}
